<?php

namespace App\Http\Controllers;

use App\Models\Pesan;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class PesanController extends Controller
{
    public function index()
    {
        $pesan = Pesan::pencarian()->latest()->paginate(10);
        $data = [
            'title' => 'Ramizah Store | Data Pesan',
            'page' => ' Data Pesan',
            'menuActive' => 'pesan',
            'menuOpen' => 'pesan',
        ];
        return view('admin.data.pesan', compact('data', 'pesan'))->with('no', 1);
    }

    public function kirim(Request $request): RedirectResponse
    {
        $request->validate(
            [
                'nama'  => 'required',
                'email'   => 'required',
                'subjek'   => 'required',
                'pesan'   => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
            ]
        );

        Pesan::create([
            'nama' => $request->nama,
            'email' => $request->email,
            'subjek' => $request->subjek,
            'pesan' => $request->pesan,
            'sts_pesan' => 'B',
        ]);

        return redirect('kontak')->with(['success' => 'Pesan Berhasil direkam, Terimakasih atas kunjungan Anda']);
    }

    public function cek_pesan()
    {
        $cek = Pesan::where('sts_pesan', 'B')->count();
        $isi = (empty($cek)) ? 0 : $cek;
        return response()->json($isi);
    }

    public function cek_data_pesan()
    {
        $cek = Pesan::where('sts_pesan', 'B')->get();
        $isi = 'notif';
        if (!empty($cek)) {
            return view('admin.data.notif_pesan', compact('cek', 'isi'));
        }
    }

    public function lihat_pesan(Request $request)
    {
        $isi = 'lihat';
        $c = Pesan::where('id', $request->id)->first();
        $c->update([
            'sts_pesan' => 'L',
        ]);
        return view('admin.data.notif_pesan', compact('c', 'isi'));
        // return response()->json();
    }

    public function destroy($id)
    {
        Pesan::findOrFail($id)->delete();
        return redirect()->route('pesan.index')->with(['success' => 'Data Berhasil Dihapus!']);
    }

    public function destroy_all_pesan(Request $request)
    {
        $ids = $request->allVals;
        foreach ($ids as  $id) {
            Pesan::where('id', $id)->delete();
        }
        return response()->json();
    }
}
